// Condicional para não quebrar instalação do pacote CLI.
// Se estiver em ambiente de build GUI com electron-builder disponível,
// tenta instalar dependências nativas. Caso contrário, sai silenciosamente.

const path = require('path');

const shouldSkip =
  process.env.EXTRATOR_SKIP_POSTINSTALL === 'true' ||
  process.env.CI === 'true' ||
  process.env.NODE_ENV === 'production-cli';

if (shouldSkip) {
  process.stdout.write('safe-postinstall: skipping (env skip).\n');
  process.exit(0);
}

try {
  // Se electron-builder não estiver instalado (ex.: instalação do pacote npm da CLI),
  // apenas ignore.
  const ebPath = require.resolve('electron-builder', { paths: [process.cwd()] });
  const eb = require(ebPath);
  if (eb.installAppDeps) {
    process.stdout.write('safe-postinstall: running electron-builder install-app-deps.\n');
    eb.installAppDeps().catch(() => process.exit(0));
  } else {
    process.stdout.write('safe-postinstall: electron-builder sem installAppDeps, ignorando.\n');
  }
} catch (err) {
  process.stdout.write('safe-postinstall: electron-builder não encontrado, ignorando.\n');
  process.exit(0);
}
