# Termos de Uso — Módulo Filhos de Minas

O módulo **Filhos de Minas** conecta-se ao repositório do **DW PEC e-SUS** para localizar atendimentos gestantes elegíveis ao programa Filhos de Minas (SES/MG). Ele coleta os seguintes dados para cada atendimento:

- **Identificador do atendimento** (`co_seq_fat_atd_ind`) e código do cidadão (`co_fat_cidadao_pec`);  
- **Nome e documento (CPF ou CNS)** da gestante;  
- **Data da última menstruação (DUM)**, respeitando o recorte de até 365 dias;  
- **CBO** registrado no atendimento;  
- **CID / CIAP** e a quantidade calculada de filhos associados a cada CID;  
- **Flag de integração local (queued)** e respostas de envio (status/message) para rastreamento.

Esses dados ficam armazenados localmente em SQLite (`module_items`) para construir o lote que será enviado ao back-end estadual através da API Key informada nas configurações. O módulo não envia nenhum dado automático até que a integração seja disparada manualmente.

O uso deste módulo pressupõe:

1. Que o operador possui autorização para acessar o DW PEC e-SUS do seu município/região.
2. Que os dados extraídos serão utilizados exclusivamente para o acompanhamento das gestantes elegíveis ao programa Filhos de Minas.
3. Que o módulo será executado em um ambiente protegido e que o arquivo local (`extrator-local.db`) está sob as políticas locais de segurança da informação.

Antes de qualquer sincronização pela interface gráfica (Windows ou Linux), leia e aceite estes termos. O sistema exibirá automaticamente esta tela ao clicar em “Abrir módulo” ou “Sincronizar banco local” sempre que ainda não houver aceite registrado.

Após aceitar, o extrator liberará as operações e marcará nos metadados locais o horário do aceite (`termsAcceptedAt`).
