# Módulo Filhos de Minas — Guia rápido

## Visão geral
- Extrai atendimentos de gestantes elegíveis do DW PEC e-SUS para envio à SES/MG.
- Mantém persistência local em SQLite (`module_items`) com ID do atendimento, nome, documento (prioriza CPF sobre CNS), DUM, CBO, CID/CIAP, qtd. filhos e flag `queued` para integração.
- Incremental: busca apenas registros com `co_seq_fat_atd_ind` maior que o último salvo. Se houver registros locais sem nome, consulta apenas esses IDs para corrigir.
- Recorte temporal: DUM (t.dt_registro) deve estar dentro dos últimos 365 dias.

## Campos extraídos
- `co_seq_fat_atd_ind` (ID)
- `nome`
- `cpf` / `cns` (usa CPF se existir; guarda `doc_tipo` cpf|cns e `cpf_ou_cns`)
- `dum` (DUM)
- `cbo`
- `cid`
- `ciap`
- `qtd_filhos`

## Fluxo (GUI)
1) Configurar DW (host/porta/usuário/senha + database Oracle/Postgres) e API Key.  
2) Abrir módulo → lista sempre o banco local (SQLite) com filtros de texto e status (`Todos | Pendentes | Informados`).  
3) Menu “Banco local ▾”:  
   - “Sincronizar banco local”: roda a query incremental no DW e salva tudo no SQLite.  
   - “Limpar banco local”: apaga os registros do módulo (confirmação).  
   - “Console SQLite”: abre console para consultas diretas (ex.: `SELECT * FROM module_items WHERE module_id='filhos_de_minas' LIMIT 10;`).  

## CLI útil
- `extrator-esus run --module=filhos_de_minas --page=1 --pageSize=10` (extrai e persiste localmente)  
- `extrator-esus sqlite --sql "SELECT COUNT(*) FROM module_items WHERE module_id='filhos_de_minas';"`  

## Observações
- Documentos: `doc_tipo` é inferido (11 dígitos = CPF; 15 = CNS); salva ambos, mas prioriza CPF para exibição/envio.
- DUM antiga (>365 dias) é descartada no próprio SQL.
- Persistência é automática em cada execução; a GUI mostra apenas a página solicitada, mas todo o lote novo é gravado no SQLite.
- Configurações exigidas incluem dados do responsável (`user.name`, `user.email`, `user.phone`, `user.city`, `user.role`) além das credenciais do DW e API Key.
- Para enviar o lote ao Filhos de Minas você também precisa preencher TODAS as configurações obrigatórias (`dw.*` e `api.user`/`api.password`) na tela de configurações; o `user.*` será usado para rastreamento do responsável e o `FILHOS_DE_MINAS_PROFESSIONAL_CODE` no `.env` fornece o código profissional. O build/`.env` já fornece a URL base (`FILHOS_DE_MINAS_API_URL`), portanto não há campo da URL no módulo.
 
## Envio ao Filhos de Minas (GUI)
- A tela interna agora mostra um botão “Enviar ao Filhos de Minas” no topo e outro no fim da tabela. Ambos disparam o mesmo fluxo (o botão é ativo apenas quando há registros não sincronizados).
-- O envio faz:
  1. `POST /auth/token` com `api.user`/`api.password` para obter o token.
  2. `POST /gestante/create/` para garantir que a gestante exista (cpf/cns + município).
  3. `POST /gestante/gravidez` com o CPF, DUM e quantidade de filhos.
  4. `POST /gestante/gravidez/consulta` com o CPF, data da consulta atual e o código do profissional.
- Cada linha enviada com sucesso ganha `queued = 1` no banco local e mostra “Enviado ao Filhos de Minas” no campo de status; falhas ficam registradas no `message_response`.
- Após o envio o sistema recarrega a página atual para mostrar o novo estado.
- O painel “Histórico de envio” agora exibe um dropdown com cada batch (`send-…`) e, ao escolher um deles, carrega apenas os logs daquela tentativa (incluindo o curl e resposta completos). Os horários shown são convertidos para o fuso de Brasília (UTC-3) para facilitar a leitura.
- Antes de executar o módulo pela interface gráfica aceite os Termos de Uso (`modules/filhos_de_minas/TERMS.md`). O sistema exibirá o modal automaticamente ao abrir o módulo se ainda não houver aceite.
