const { contextBridge, ipcRenderer } = require('electron');
const coreVersion = process.env.npm_package_version || process.env.APP_VERSION || 'dev';

contextBridge.exposeInMainWorld('extrator', {
  listModules: () => ipcRenderer.invoke('modules:list'),
  getManifest: (moduleId) => ipcRenderer.invoke('modules:manifest', moduleId),
  runModule: (moduleId, params) => ipcRenderer.invoke('modules:run', moduleId, params),
  getConfig: (moduleId) => ipcRenderer.invoke('modules:config:get', moduleId),
  updateConfig: (moduleId, updates) =>
    ipcRenderer.invoke('modules:config:update', moduleId, updates),
  getModuleTerms: (moduleId) => ipcRenderer.invoke('modules:terms', moduleId),
  sendFilhosDeMinas: (options) =>
    ipcRenderer.invoke('modules:filhos-de-minas:send', options),
  getFilhosLogs: (options) =>
    ipcRenderer.invoke('modules:filhos-de-minas:logs', options),
  getFilhosLogMessages: (options) =>
    ipcRenderer.invoke('modules:filhos-de-minas:log-messages', options),
  checkCoreUpdates: () => ipcRenderer.invoke('updates:core'),
  autoUpdateCore: (options) => ipcRenderer.invoke('updates:core:auto', options),
  alertUpdate: (message) => ipcRenderer.invoke('updates:alert', message),
  runSql: (sql) => ipcRenderer.invoke('sqlite:run', sql),
  listLocalItems: (moduleId, options) => ipcRenderer.invoke('modules:local-list', moduleId, options),
  clearLocalItems: (moduleId) => ipcRenderer.invoke('modules:local-clear', moduleId),
  coreVersion,
  getCoreVersion: () => ipcRenderer.invoke('core:version'),
  platform: process.platform
});
