const path = require('path');
const os = require('os');

function resolveRootDir() {
  if (process.env.EXTRATOR_USER_DATA_DIR) {
    return path.resolve(process.env.EXTRATOR_USER_DATA_DIR);
  }
  if (process.env.EXTRATOR_HOME_DIR) {
    return path.resolve(process.env.EXTRATOR_HOME_DIR);
  }
  return path.join(os.homedir(), '.extrator-pec-esus');
}

function resolveConfigDirRoot() {
  return path.join(resolveRootDir(), 'config');
}

function resolveDataDirRoot() {
  return path.join(resolveRootDir(), 'data');
}

function resolveUpdatesDirRoot() {
  return path.join(resolveRootDir(), 'updates');
}

module.exports = {
  resolveRootDir,
  resolveConfigDirRoot,
  resolveDataDirRoot,
  resolveUpdatesDirRoot
};
