# CLI – Extrator PEC e-SUS (Windows/Linux)

## Pré-requisitos
- Windows 10/Server 2016+ 64 bits ou Linux x64.
- Node.js 18+ instalado.

## Instalação do pacote CLI (tgz)
1. Gere ou baixe o pacote (ex.: `extrator-pec-esus-{versao}.tgz`).
2. No PowerShell/CMD (Windows) ou shell (Linux), instale global:
   - Opcional: pular postinstall de Electron: `set EXTRATOR_SKIP_POSTINSTALL=true` (PowerShell/CMD) ou `export EXTRATOR_SKIP_POSTINSTALL=true` (Linux).
   - Instalação:  
     `npm i -g "C:\caminho\extrator-pec-esus-{versao}.tgz"` (Windows)  
     `npm i -g /caminho/extrator-pec-esus-{versao}.tgz` (Linux)
3. Se o PowerShell bloquear scripts, use o shim `.cmd` ou CMD:  
   `& "C:\Program Files\nodejs\extrator-esus.cmd" list-modules`  
   ou `cmd /c extrator-esus list-modules`.

## Variáveis de ambiente (opcional, para endpoints reais)
Defina no mesmo shell antes de rodar:
```
UPDATE_CORE_URL=https://...
UPDATE_MODULES_URL=https://...
UPDATE_MODULE_DETAIL_URL=https://.../{id}   # opcional
EXTRATOR_SHARED_KEY=<sua-chave>
UPDATE_DOWNLOAD_DIR=<pasta>                 # opcional, padrão: ~/.extrator-pec-esus/updates/core
```
## Configurações sensíveis do módulo
Os campos `baseUrl` (endpoint do Filhos de Minas) e `core.updateUrl` (sobrescreve a URL de updates do core) ficam ocultos na GUI até você pressionar `Ctrl+K+S`, mas podem ser editados diretamente pela CLI usando `config-set`. Exemplo:

```
extrator-esus config-set --module filhos_de_minas --set baseUrl=https://filhos.example.com/api
extrator-esus config-set --module __global__ --set core.updateUrl=https://updates.example.com/core
```

Assim como na GUI, esses valores são persistidos em `config/modules-config.json` e usados por `send-filhos`/`check-updates` mesmo quando o pacote CLI está isolado. Use `config-get --module filhos_de_minas` para confirmar os valores armazenados.

## Comandos disponíveis
- `extrator-esus list-modules`  
  Lista módulos instalados, status de atualização/bloqueio.

- `extrator-esus check-updates`  
  Checa atualizações do core e módulos.

- `extrator-esus update-core [--download-dir <dir>] [--apply false]`  
  Baixa e (por padrão) executa o instalador do core para o SO atual.

- `extrator-esus run --module <id> [--page 1] [--pageSize 100] [--filter ""]`  
  Executa/sincroniza um módulo (mesma lógica da UI: busca dados e persiste no SQLite local).

- `extrator-esus local-list --module <id> [--filter ""] [--queued all|queued|pending] [--status all|success|error|none] [--page 1] [--pageSize 25]`  
  Lista registros locais do módulo com paginação/filtros (equivalente à tela da UI ao abrir o módulo).

- `extrator-esus local-clear --module <id>`  
  Limpa todos os registros locais do módulo.

- `extrator-esus config-get --module <id>`  
  Exibe configurações atuais do módulo e indica quais obrigatórias estão faltando (conforme o manifest).
  Senhas e valores sensíveis são mascarados ao mostrar o comando (a CLI usa o tipo/sensitive dos campos para esconder os dados).

- `extrator-esus config-set --module <id> [--set key=valor ...] [--json caminho.json]`  
  Define configurações do módulo via pares key=valor ou carregando de um arquivo JSON.

- `extrator-esus send-filhos [--limit <n>]`  
  Envia os itens pendentes do módulo `filhos_de_minas` ao endpoint oficial (mesma ação do botão “Enviar ao Filhos de Minas” da GUI). O módulo precisa ter `termsAccepted=true`.
  O envio só ocorre depois de preencher todas as `requiredSettings` do módulo e aceitar os termos (use `config-get`/`config-set` para preencher os campos obrigatórios antes de rodar `send-filhos`).

- `extrator-esus uninstall`  
  Remove o banco local, configurações e downloads do CLI (limpa `~/.extrator-pec-esus`). O binário continua no sistema; execute `npm uninstall -g extrator-pec-esus` para remover o comando.

- `extrator-esus logs --module <id> [--limitAttempts 6] [--limitEntries 100] [--status all|success|error] [--action <nome>] [--search <texto>] [--message <texto>] [--attemptId <id>]`  
  Mostra o resumo de batches e as entradas de log compatíveis com os filtros (status, ação, busca em mensagem/detalhes, ID do lote).

- `extrator-esus log-messages --module <id> --action <nome> [--attemptId <id>]`  
  Lista as mensagens distintas registradas para uma ação específica (útil para reproduzir o filtro “Mensagem” da GUI).

- `extrator-esus sqlite --sql "<consulta>"`  
  Executa SQL direto no banco local (`db.sqlite`/`extrator-local.db`). Ex.:  
  `extrator-esus sqlite --sql "SELECT * FROM module_items WHERE module_id='filhos_de_minas' ORDER BY item_id DESC LIMIT 20;"`

A CLI agora replica os principais controles da GUI: `send-filhos` corresponde ao botão “Enviar ao Filhos de Minas”, `logs` traz o resumo/entradas dos batches e `log-messages` disponibiliza as mesmas opções de filtro de mensagens que você vê na aba de logs da interface.

## Logs de sincronização

Use `extrator-esus logs --module filhos_de_minas --action send.item` para ver o resumo das últimas tentativas e listar as entradas mais recentes com filtros por ação, status ou termo de busca. Quando quiser reproduzir o dropdown “Mensagem” da GUI, combine `log-messages` com `--action send.api_error` e (opcional) `--attemptId <id>` para ver cada mensagem distinta.

- `extrator-esus help`  
  Mostra o guia rápido de comandos e aponta para este manual.

## Onde ficam os dados/updates no CLI
- Diretório base: `~/.extrator-pec-esus` (ou o caminho definido por `EXTRATOR_HOME_DIR`/`EXTRATOR_USER_DATA_DIR`). Se precisar separar o `config`, use `EXTRATOR_CONFIG_DIR`.
- Banco local SQLite: `~/.extrator-pec-esus/extrator-local.db` (ou qualquer caminho indicado em `EXTRATOR_DB_PATH` ou em `data/extrator-local.db` quando estiver trabalhando no código-fonte).
- Downloads de update do core: `~/.extrator-pec-esus/updates/core` (ou `UPDATE_DOWNLOAD_DIR` se definido).
- Execute `extrator-esus uninstall` para limpar completamente o diretório base (`~/.extrator-pec-esus`).
- O pacote CLI (`npm pack` ou `npm run build:cli`) usa a lista de arquivos explicitada em `package.json`, então `data/`, `.env` e outras pastas pessoais não são incluídas no `.tgz` final.

## Desinstalação
`npm uninstall -g extrator-pec-esus`

## Dicas
- Se `better-sqlite3` reclamar de binário no Windows, reinstale no ambiente nativo (não via WSL) e rode `npm install` (ou use o pacote `.tgz` construído no próprio Windows).
- SmartScreen no instalador do core: clique em “Mais informações” → “Executar assim mesmo”.
- **Instalação alternativa via Snap (Linux)**  
  Se o pacote Snap estiver publicado, instale com `sudo snap install extrator-pec-esus --dangerous` (para `.snap` local) ou apenas `sudo snap install extrator-pec-esus` (caso o snap esteja no canal oficial). Após instalar, o comando `extrator-pec-esus` já fica disponível no PATH. Para remover: `sudo snap remove extrator-pec-esus`.
