# Extrator PEC e-SUS — Visão Arquitetural 1.1

## 1. Identificação
- **Nome:** Extrator PEC e-SUS  
- **Tipo:** Aplicação multiplataforma para extração e envio de dados do DW PEC e-SUS para programas governamentais (executa no servidor do município, extraindo do PEC e enviando para a SES de forma transparente e pactuada).  
- **Tecnologias:** Electron (GUI), Node.js (core engine), CLI integrada  
- **Objetivo:** Plataforma capaz de receber módulos plugáveis de extração, com regras e configs próprias, oferecendo operação padronizada, segura, atualizável e extensível.  
- **Arquiteto:** Emerson Udovic / Montreal  

## 2. Stakeholders
- **Desenvolvedores:** Implementam core, módulos, engine, UI e CLI.  
- **Equipe de Dados Estadual:** Consome dados extraídos e garante padronização de schemas.  
- **Programas Governamentais (Filhos de Minas, Alexus, etc.):** Recebem dados, validam cargas e garantem integridade.  
- **Usuários Finais (Gestores e TI Municipais):** Operam extrações, configuram acessos e executam módulos.  
- **Equipe de Segurança:** Garante atualizações críticas e conformidade.  
- **Infraestrutura:** Publica atualizações, hospeda endpoints e garante integridade dos pacotes.  

## 3. Escopo
Cobre: arquitetura do core (Electron + Node engine), arquitetura de módulos externos, UI (rack de módulos, telas internas, configuração), CLI, modelo de atualização (segurança/negócio), fluxos de execução, regras de configuração, persistência local e estrutura de diretórios.  
Fora do escopo: implementação específica de cada módulo, backend estadual e modelo de dados interno do DW PEC e-SUS.  

## 4. Contexto do Sistema
Componentes principais:
- **Core Electron + Node Engine:** carrega módulos, valida versões/configs, executa módulos em subprocessos, expõe API interna.  
- **Módulos Plugáveis:** `module.json`, código Node próprio, requisitos de config, comandos GUI/CLI, versão/histórico. Funções expostas: `run(params)`, `testConnection()`, `validateConfig()`.  
- **Interfaces:** GUI (renderer) e CLI com comandos equivalentes.  

## 5. Requisitos
- **RF:** multiplataforma; GUI + CLI; módulos plugáveis (instalar/atualizar/ativar/executar); validação de configs obrigatórias; execução de módulos para extrair e enviar dados; logs por módulo (GUI + arquivos); atualizações de segurança obrigatórias (core/módulos) e de negócio opcionais; rack inicial com status/ações.  
- **RNF:** segurança (criptografia local, integridade de módulos); extensibilidade (novos módulos sem alterar core); observabilidade (logs por módulo/core); performance (UI não bloqueada); confiabilidade (atualização não corrompe instalados).  

## 6. Interface e Comandos
- **GUI (renderer):** rack de módulos, configuração, log, tela interna do módulo, tela de atualização obrigatória.  
- **CLI:**  
  - `extrator-esus list-modules`  
  - `extrator-esus run --module=<id> --params...`  
  - `extrator-esus check-updates`  
  - `extrator-esus update --module=<id>`  

## 7. Atualizações
- **Tipos:** `security` (obrigatória) e `business` (opcional) para core e módulos.  
- **Core:** update de segurança bloqueia app até atualizar; de negócio apenas notifica.  
- **Módulos:** segurança bloqueia módulo; negócio exibe badge/alerta.  
- **Decisão técnica:** comparar `currentVersion` vs releases; se existir `security` `mandatory=true` acima da versão → bloqueio. Se apenas `business` acima → badge.  
- **Fluxo:** download via URL do serviço, validação de checksum, substituição in-place (mantendo configs, módulos e logs), reinício do core quando aplicável.  

## 8. Fluxos
- **Seleção de módulo:** valida configs obrigatórias, verifica atualizações; se faltar config → tela de config; se update de segurança → bloqueio; senão entra.  
- **Execução de extração:** inicia subprocesso, acessa DW, exibe resumo e detalhamento/filtros, confirma exportação, aciona API/fila, registra logs.  
- **Edição de configs:** abre tela de configuração, usuário salva/cancela.  

## 9. Estrutura de Diretórios (proposta)
```
extrator-esus/
 ├─ app/
 │   ├─ main/          # Electron main process
 │   ├─ renderer/      # GUI
 │   ├─ core/          # Engine de módulos, atualizações e config
 │   └─ cli/           # Comandos CLI
 ├─ modules/
 │   ├─ filhos_de_minas/
 │   │   ├─ module.json
 │   │   ├─ index.js
 │   └─ outros_modulos/
 ├─ config/
 │   └─ modules-config.json
 ├─ logs/
 │   └─ <module-id>/YYYY-MM-DD.log
 └─ package.json
```

## 10. Manifesto do Módulo (module.json)
```json
{
  "id": "filhos_de_minas",
  "name": "Filhos de Minas",
  "version": "1.0.0",
  "minAppVersion": "1.0.0",
  "requiredSettings": [
    { "key": "dw.host", "type": "string", "title": "Host do DW PEC e-SUS", "description": "Endereço do servidor de banco de dados do DW PEC e-SUS (ex: dw-esus.saude.mg.gov.br)." },
    { "key": "dw.user", "type": "string", "title": "Usuário do DW", "description": "Usuário com permissão de leitura no DW PEC e-SUS." },
    { "key": "dw.password", "type": "secret", "title": "Senha do DW", "description": "Senha do usuário de acesso ao DW PEC e-SUS. Será armazenada de forma segura." },
    { "key": "api.key", "type": "secret", "title": "API Key do Programa Estadual", "description": "Chave de autenticação para enviar os dados extraídos ao sistema do programa (ex: Filhos de Minas)." }
  ],
  "commands": {
    "gui": ["run_extraction", "test_connection"],
    "cli": ["run"]
  }
}
```

## 11. Endpoints de Atualização (modelo)
- Core: `GET https://updates.extrator-pec-esus.mg.gov.br/extrator/core`
- Todos os módulos: `GET https://updates.extrator-pec-esus.mg.gov.br/extrator/modules`
- Detalhe de módulo: `GET https://updates.extrator-pec-esus.mg.gov.br/extrator/modules/{id}`

Com a resposta, o core determina bloqueio/alerta seguindo as regras de segurança/negócio e retorna para a UI algo como:
```json
{
  "canRun": false,
  "reason": "security_update_required",
  "updates": { "security": [...], "business": [...] }
}
```

## 12. Query do primeiro módulo (Filhos de Minas)
A extração roda a consulta abaixo no DW PEC e-SUS:
```sql
WITH ciaps_gestante AS (
    SELECT co_seq_dim_ciap
    FROM tb_dim_ciap
    WHERE nu_ciap IN ('W78','W79','W81','W84','W85')
),
cids_gestante AS (
    SELECT co_seq_dim_cid
    FROM tb_dim_cid
    WHERE nu_cid IN (
        'O11',
        'O120','O121','O122',
        'O13',
        'O140','O141','O149',
        'O150','O151','O159',
        'O16',
        'O200','O208','O209',
        'O210','O211','O212','O218','O219',
        'O220','O221','O222','O223','O224','O225','O228','O229',
        'O230','O231','O232','O233','O234','O235','O239',
        'O299',
        'O300','O301','O302','O308','O309',
        'O311','O312','O318',
        'O320','O321','O322','O323','O324','O325','O326','O328','O329',
        'O330','O331','O332','O333','O334','O335','O336','O337','O338',
        'O752','O753',
        'O990','O991','O992','O993','O994',
        'O240','O241','O242','O243','O244','O249',
        'O25',
        'O260','O261','O263','O264','O265','O268','O269',
        'O280','O281','O282','O283','O284','O285','O288','O289',
        'O290','O291','O292','O293','O294','O295','O296','O298',
        'O339',
        'O340','O341','O342','O343','O344','O345','O346','O347','O348','O349',
        'O350','O351','O352','O353','O354','O355','O356','O357','O358','O359',
        'O360','O361','O362','O363','O365','O366','O367','O368','O369',
        'O40',
        'O410','O411','O418','O419',
        'O430','O431','O438','O439',
        'O440','O441',
        'O460','O468','O469',
        'O470','O471','O479',
        'O48',
        'O995','O996','O997',
        'Z640',
        'O10','O12','O14','O15','O20','O21','O22','O23','O24',
        'O26','O28','O29','O30','O31','O32','O33','O34','O35','O36',
        'O41','O43','O44','O46','O47','O98',
        'Z34','Z35','Z36','Z33',
        'Z340','Z348','Z349',
        'Z350','Z351','Z352','Z353','Z354','Z357','Z358','Z359'
    )
),
cid_multifetal AS (
    SELECT d.co_seq_dim_cid, t.qtd_filhos
    FROM (VALUES
        ('O300', 2),
        ('O301', 3),
        ('O302', 4)
    ) AS t(nu_cid, qtd_filhos)
    JOIN tb_dim_cid d ON d.nu_cid = t.nu_cid
),
cbo_elegivel AS (
    SELECT co_seq_dim_cbo
    FROM tb_dim_cbo
    WHERE nu_cbo LIKE '2251%' OR nu_cbo LIKE '2235%'
),
atendimentos_gestantes AS (
    SELECT DISTINCT
        p.co_seq_fat_atend_ind_problemas,
        a.co_seq_fat_atd_ind,
        a.co_fat_cidadao_pec,
        a.co_dim_tempo_dum,
        CASE
            WHEN cb1.co_seq_dim_cbo IS NOT NULL THEN a.co_dim_cbo_1
            WHEN cb2.co_seq_dim_cbo IS NOT NULL THEN a.co_dim_cbo_2
        END AS co_dim_cbo,
        p.co_dim_cid,
        p.co_dim_ciap
    FROM tb_fat_atd_ind_problemas p
    JOIN tb_fat_atendimento_individual a ON a.co_seq_fat_atd_ind = p.co_fat_atd_ind
    LEFT JOIN cbo_elegivel cb1 ON cb1.co_seq_dim_cbo = a.co_dim_cbo_1
    LEFT JOIN cbo_elegivel cb2 ON cb2.co_seq_dim_cbo = a.co_dim_cbo_2
    LEFT JOIN cids_gestante  cg ON cg.co_seq_dim_cid  = p.co_dim_cid
    LEFT JOIN ciaps_gestante ci ON ci.co_seq_dim_ciap = p.co_dim_ciap
    WHERE
        a.co_dim_tempo_dum IS NOT NULL
        AND (cg.co_seq_dim_cid IS NOT NULL OR ci.co_seq_dim_ciap IS NOT NULL)
        AND (cb1.co_seq_dim_cbo IS NOT NULL OR cb2.co_seq_dim_cbo IS NOT NULL)
),
qtd_filhos_por_gestacao AS (
    SELECT
        ag.co_fat_cidadao_pec,
        ag.co_dim_tempo_dum,
        COALESCE(MAX(mf.qtd_filhos), 1) AS qtd_filhos
    FROM atendimentos_gestantes ag
    LEFT JOIN tb_fat_atd_ind_problemas p2 ON p2.co_fat_atd_ind = ag.co_seq_fat_atd_ind
    LEFT JOIN cid_multifetal mf ON mf.co_seq_dim_cid = p2.co_dim_cid
    GROUP BY ag.co_fat_cidadao_pec, ag.co_dim_tempo_dum
)
SELECT DISTINCT
    c.no_cidadao                          AS nome,
    COALESCE(a.nu_cpf_cidadao, a.nu_cns)  AS cpf_ou_cns,
    t.dt_registro                         AS dum,
    cbo.nu_cbo                            AS cbo,
    dc.nu_cid                             AS cid,
    di.nu_ciap                            AS ciap,
    q.qtd_filhos
FROM atendimentos_gestantes ag
JOIN tb_fat_atendimento_individual a ON a.co_seq_fat_atd_ind = ag.co_seq_fat_atd_ind
LEFT JOIN tb_fat_cidadao_pec fcp ON a.co_fat_cidadao_pec = fcp.co_seq_fat_cidadao_pec
LEFT JOIN tb_cidadao c ON fcp.co_cidadao = c.co_seq_cidadao
LEFT JOIN tb_dim_cbo cbo ON cbo.co_seq_dim_cbo = ag.co_dim_cbo
LEFT JOIN tb_dim_cid dc ON dc.co_seq_dim_cid = ag.co_dim_cid
LEFT JOIN tb_dim_ciap di ON di.co_seq_dim_ciap = ag.co_dim_ciap
LEFT JOIN tb_dim_tempo t ON t.co_seq_dim_tempo = ag.co_dim_tempo_dum
JOIN qtd_filhos_por_gestacao q
  ON q.co_fat_cidadao_pec = ag.co_fat_cidadao_pec
 AND q.co_dim_tempo_dum   = ag.co_dim_tempo_dum
ORDER BY c.no_cidadao, t.dt_registro;
```

## 13. Persistência local e incremental (core)
- Banco local SQLite (`data/extrator-local.db` ou `EXTRATOR_DB_PATH`), tabela `module_items` com flag `queued` e `doc_tipo` (cpf|cns).
- Execuções trazem apenas IDs maiores que o último persistido (`co_seq_fat_atd_ind`) e persistem tudo que é novo na mesma rodada (GUI mostra só a página, mas o módulo salva o lote completo).
- Reparo pontual: se registros locais estiverem sem nome, o módulo busca apenas esses IDs no DW e atualiza o SQLite (sem full sync).
- Console SQLite: GUI (menu “Banco local ▾ → Console SQLite”) ou CLI `extrator-esus sqlite --sql "<consulta>"`.
- Filtro de status na GUI: `Todos | Pendentes (queued=0) | Informados (queued=1)` diretamente do SQLite.

## 14. Módulos documentados
- [Filhos de Minas](modules/filhos_de_minas/README.md)
- [Guia de construção de módulos](modules/README.md)

## 15. Build de executáveis (Linux/Windows)
### Scripts
- Linux: `npm run build:linux` (gera AppImage/Snap em `dist/`).
- Windows: `npm run build:win` (gera instalador em `dist\`).
- Todos: `npm run build:all`.
- Pós-install já recompila nativos: `electron-builder install-app-deps` (rodado via `postinstall`).
- Ícones do app: gerados a partir do logo PEC e-SUS (por padrão `https://extratorpecesus.blob.core.windows.net/releases/logo-pec.png`). Use `npm run generate:icons` para baixar e criar `build/icon.png` (ele gera também 256/512/1024). `electron-builder` usa `build/icon.png` como base para todos os destinos. Se quiser outro logo, defina `LOGO_URL=<url>` ao rodar o script.

### Passo a passo (exemplo)
- Linux/WSL: (NO WSL)
  1. `npm install`
  2. `npm run build:linux`
- Windows (NO CMD Admin ou Modo Desenvolvedor ativo):
  1. `pushd \\wsl.localhost\Ubuntu\home\{usuario}\projects\extrator-pec-esus` (ajuste o caminho)
  2. `npm install`
  3. `npm run build:win`

### Cache e casos especiais (Windows)
- Se aparecer erro de extração de `.7z`/assinatura: `rmdir /S /Q "%LOCALAPPDATA%\\electron-builder\\Cache\\winCodeSign"` e rebuild.
- Se não quiser usar CMD Admin, ative o Modo Desenvolvedor do Windows (libera symlink); depois pode usar CMD normal.

### Possíveis problemas e soluções
- **ABI nativa (better-sqlite3)**: erros `NODE_MODULE_VERSION` ou bindings faltando → `npx electron-rebuild -f -w better-sqlite3` ou reinstalar dependências e rodar `npm install`.
- **URLs de update**: configure `.env` (`UPDATE_CORE_URL`, `UPDATE_MODULES_URL`, `EXTRATOR_SHARED_KEY`); sem elas, checagem de update falha.
- **node_modules/dados locais no Git**: já ignorados em `.gitignore`; reinstale deps em cada ambiente.
- **Windows SmartScreen no instalador**: ao abrir o instalador baixado, se surgir a tela azul do SmartScreen, clique em “Mais informações” → “Executar assim mesmo” (binário ainda não assinado).

## 13. Próximos Passos Sugeridos
- Desenhar API interna entre core e módulos (contrato de chamadas/IPC e CLI).  
- Definir formato de pacotes de atualização (URL, checksum, assinatura).  
- Prototipar CLI mínima (`list-modules`, `run`, `check-updates`).  
- Criar mock do módulo Filhos de Minas com a query acima e `module.json` de exemplo.  

## Como rodar localmente (GUI e CLI)
- Requisitos: Node.js 18+ (obrigatório para CLI e para build).  
- Instale dependências: `npm install`.  
- GUI (Electron): `npm run dev -- --enable-logging --v=3 --log-level=0 --remote-debugging-port=9222 --inspect --disable-gpu --no-sandbox`.  
- CLI (código-fonte): `npm run cli -- list-modules` ou binário `extrator-esus list-modules` (via `npm link` para global).  
- Checar updates: `npm run check-updates` (usa mocks se `USE_UPDATE_MOCK=true`).  
- Estrutura principal já criada em `app/main` (Electron), `app/renderer` (GUI), `app/core` (engine/updates/config), `app/cli` (CLI), `modules/filhos_de_minas` (módulo exemplo) e `config/modules-config.json` (configs).  

### Build/empacote CLI para distribuição
- Requisito: Node 18+.  
- Gere um pacote npm (CLI + engine) com `npm run build:cli` (equivale a `npm pack`), ou publique em um registry.  
- Uso do pacote publicado/gerado: `npm i -g extrator-pec-esus` (ou `npm i -g ./extrator-pec-esus-<versao>.tgz`) e depois `extrator-esus list-modules`, `extrator-esus run <moduleId>`, `extrator-esus check-updates`, `extrator-esus update-core`.  
- O CLI usa os mesmos endpoints/variáveis de ambiente de update do core/módulos e grava downloads em `~/.extrator-pec-esus/updates/core` (padrão) ou no caminho definido em `UPDATE_DOWNLOAD_DIR`.  

### Sobre updates (stub)
- Por padrão, o cliente considera o serviço de atualização indisponível e mostra “Sem conexão com atualizações”.
- Para habilitar o mock de updates descrito no documento, rode com `USE_UPDATE_MOCK=true npm run dev` ou no CLI `USE_UPDATE_MOCK=true npm run check-updates`.
- Para usar endpoints reais, defina as variáveis de ambiente:
  - `UPDATE_CORE_URL` (ex.: `https://updates.extrator-pec-esus.mg.gov.br/extrator/core`)
  - `UPDATE_MODULES_URL` (ex.: `https://updates.extrator-pec-esus.mg.gov.br/extrator/modules`)
  - `UPDATE_MODULE_DETAIL_URL` (opcional, ex.: `https://updates.extrator-pec-esus.mg.gov.br/extrator/modules/{id}`)
  - Sem `USE_UPDATE_MOCK`, o app tenta esses endpoints; se falhar, mostra “Sem conexão com atualizações”.
  - `UPDATE_CORE_DOWNLOAD_BASE` para montar a URL do artefato do core conforme o SO (padrão: `https://updates.extrator-pec-esus.mg.gov.br/extrator/core/<platform>/<arch>/<version>.zip`).
  - (novo) `UPDATE_DOWNLOAD_DIR` para escolher onde salvar instaladores baixados (padrão: `data/updates`).
  - Use `Ctrl+K+S` no módulo Filhos de Minas para alternar a visibilidade dos campos sensíveis `baseUrl` e `core.updateUrl` (começam ocultos).
- Novo comando CLI: `extrator-esus update-core` identifica o SO atual, baixa o artefato correspondente (ou URL específica recebida em `artifacts` do serviço de update) e tenta executar o instalador automaticamente. Use `--no-apply` se quiser apenas baixar e instalar manualmente.

`baseUrl` (substitui `FILHOS_DE_MINAS_API_URL`) e `core.updateUrl` (override de `UPDATE_CORE_URL`) começam ocultos na tela de configuração do módulo Filhos de Minas; pressione `Ctrl+K+S` para alternar a visibilidade e edite os valores conforme necessário. Assim que salvos, os valores são persistidos em `config/modules-config.json` (`core.updateUrl` sob o módulo especial `__global__`) e passam a reger os fluxos de envio/atualização.
